--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- The timer library provides helper functions for creating delayed executors.
--- 
--- !!! warning "Timers get canceled when loading saves."
--- 	All active timers will be canceled right before the [`loaded`](../events/loaded.md) event triggers. Consider using a [persistent timer](https://mwse.github.io/MWSE/apis/timer/#timerregister) if you need it to persist between game sessions.
--- 
--- @class timerlib
--- @field active any Constant to represent a timer that is actively running.
--- @field expired any Constant to represent a timer that has completed.
--- @field game any Constant to represent timers that run based on in-world time. Their clock is measured in game-scale hours.
--- @field paused any Constant to represent a timer that is paused.
--- @field real any Constant to represent timers that run in real-time. Their time is measured in seconds.
--- @field simulate any Constant to represent timers that run when the game isn't paused - the game's menus are closed. It matches the `simulate` event's timing. If the game is simulating, simulate events and simulate timers progress. Duration is measured in seconds.
timer = {}

--- Creates a timer that will finish the next frame. It defaults to the next simulation frame.
--- 
--- !!! tip
--- 	It's recommended to study the [Object Lifetimes](../guides/object-lifetimes.md) guide. It describes how to safely use [tes3reference](../types/tes3reference.md) objects inside timer callbacks.
--- @param callback fun(e: mwseTimerCallbackData) The callback function that will execute when the timer expires.
--- @param type? integer *Default*: ``timer.simulate``. Type of the timer. This value can be `timer.simulate`, `timer.game` or `timer.real`.
--- @return mwseTimer timer No description yet available.
function timer.delayOneFrame(callback, type) end

--- Registers a named timer with a callback to persist between game sessions. Bear in mind that nothing in MWSE is sandboxed, so all the registered timers are in the global namespace. Consider prefixing your timer with mod name or something else to avoid name collisions. For instance, `iceCreamMod:myTimer`.
--- 
--- !!! tip
--- 	It's recommended to study the [Object Lifetimes](../guides/object-lifetimes.md) guide. It describes how to safely use [tes3reference](../types/tes3reference.md) objects inside timer callbacks.
---
--- [Examples available in online documentation](https://mwse.github.io/MWSE/apis/timer/#timerregister).
--- @param name string Name of the registered timer.
--- @param fn fun(e: mwseTimerCallbackData) A callback function for the timer.
function timer.register(name, fn) end

--- Creates a timer.
--- !!! warning "Timers get canceled when loading saves."
--- 	All active timers will be canceled right before the [`loaded`](../events/loaded.md) event triggers.
--- 
--- !!! tip
--- 	It's recommended to study the [Object Lifetimes](../guides/object-lifetimes.md) guide. It describes how to safely use [tes3reference](../types/tes3reference.md) objects inside timer callbacks.
---
--- [Examples available in online documentation](https://mwse.github.io/MWSE/apis/timer/#timerstart).
--- @param params timer.start.params This table accepts the following values:
--- 
--- `type?`: integer — *Default*: ``timer.simulate``. Type of the timer. This value can be `timer.simulate`, `timer.game` or `timer.real`.
--- 
--- `duration`: number — Duration of the timer. The method of time passing depends on the timer type.
--- 
--- `callback`: fun(e: mwseTimerCallbackData)|string — The callback function that will execute when the timer expires. If starting a registered timer, this needs to be the `name` string passed to `timer.register`.
--- 
--- `iterations?`: integer — *Default*: `1`. The number of iterations to run. Use `-1` for infinite looping.
--- 
--- `persist?`: boolean — *Default*: `true`. Registering a timer with persist flag set to `true` will serialize the callback string in the save to persist between sessions. Only a registered timer will persist between sessions. See `timer.register()`.
--- 
--- `data?`: table — *Optional*. Data to be attached to the timer. If this is a persistent timer, the data must be json-serializable, matching the same limitations as data stored on references.
--- @return mwseTimer timer No description yet available.
function timer.start(params) end

---Table parameter definitions for `timer.start`.
--- @class timer.start.params
--- @field type? integer *Default*: ``timer.simulate``. Type of the timer. This value can be `timer.simulate`, `timer.game` or `timer.real`.
--- @field duration number Duration of the timer. The method of time passing depends on the timer type.
--- @field callback fun(e: mwseTimerCallbackData)|string The callback function that will execute when the timer expires. If starting a registered timer, this needs to be the `name` string passed to `timer.register`.
--- @field iterations? integer *Default*: `1`. The number of iterations to run. Use `-1` for infinite looping.
--- @field persist? boolean *Default*: `true`. Registering a timer with persist flag set to `true` will serialize the callback string in the save to persist between sessions. Only a registered timer will persist between sessions. See `timer.register()`.
--- @field data? table *Optional*. Data to be attached to the timer. If this is a persistent timer, the data must be json-serializable, matching the same limitations as data stored on references.

